/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.43 $ of : mfd-interface.m2c,v $ 
 *
 * $Id: ipAddressTable_interface.c,v 1.10 2004/10/18 03:53:20 rstory Exp $
 */
/*
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 * ***                                                               ***
 * ***  NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THIS FILE DOES NOT CONTAIN ANY USER EDITABLE CODE.      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THE GENERATED CODE IS INTERNAL IMPLEMENTATION, AND      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***    IS SUBJECT TO CHANGE WITHOUT WARNING IN FUTURE RELEASES.   ***
 * ***                                                               ***
 * ***                                                               ***
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 */

/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ipAddressTable.h"


#include <net-snmp/library/container.h>

#include "ipAddressTable_interface.h"

/**********************************************************************
 **********************************************************************
 ***
 *** Table ipAddressTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * ipAddressTable is subid 34 of ip.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.34, length: 8
 */
typedef struct ipAddressTable_interface_ctx_s {

    netsnmp_container *container;
    netsnmp_cache  *cache;      /* optional cache */

    ipAddressTable_registration_ptr user_ctx;

    netsnmp_table_registration_info tbl_info;

    netsnmp_baby_steps_access_methods access_multiplexer;

} ipAddressTable_interface_ctx;

static ipAddressTable_interface_ctx ipAddressTable_if_ctx;

static void     _ipAddressTable_container_init(ipAddressTable_interface_ctx
                                               * if_ctx);


static Netsnmp_Node_Handler _mfd_ipAddressTable_pre_request;
static Netsnmp_Node_Handler _mfd_ipAddressTable_post_request;
static Netsnmp_Node_Handler _mfd_ipAddressTable_object_lookup;
static Netsnmp_Node_Handler _mfd_ipAddressTable_get_values;
static Netsnmp_Node_Handler _mfd_ipAddressTable_check_objects;
static Netsnmp_Node_Handler _mfd_ipAddressTable_undo_setup;
static Netsnmp_Node_Handler _mfd_ipAddressTable_set_values;
static Netsnmp_Node_Handler _mfd_ipAddressTable_undo_cleanup;
static Netsnmp_Node_Handler _mfd_ipAddressTable_undo_values;
static Netsnmp_Node_Handler _mfd_ipAddressTable_commit;
static Netsnmp_Node_Handler _mfd_ipAddressTable_undo_commit;
static Netsnmp_Node_Handler _mfd_ipAddressTable_check_dependencies;

NETSNMP_STATIC_INLINE int
                _ipAddressTable_undo_column(ipAddressTable_rowreq_ctx * rowreq_ctx,
                                            netsnmp_variable_list * var,
                                            int column);
NETSNMP_STATIC_INLINE int
                _ipAddressTable_check_indexes(ipAddressTable_rowreq_ctx * rowreq_ctx);

/**
 * @internal
 * Initialize the table ipAddressTable 
 *    (Define its contents and how it's structured)
 */
void
_ipAddressTable_initialize_interface(ipAddressTable_registration_ptr
                                     reg_ptr, u_long flags)
{
    netsnmp_baby_steps_access_methods *access_multiplexer =
        &ipAddressTable_if_ctx.access_multiplexer;
    netsnmp_table_registration_info *tbl_info =
        &ipAddressTable_if_ctx.tbl_info;
    netsnmp_handler_registration *reginfo;
    netsnmp_mib_handler *handler;
    int             mfd_modes = 0;

    DEBUGMSGTL(("internal:ipAddressTable:_ipAddressTable_initialize_interface", "called\n"));


    /*************************************************
     *
     * save interface context for ipAddressTable
     */
    /*
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(tbl_info, ASN_INTEGER,
                                               /** index: ipAddressAddrType */
                                     ASN_OCTET_STR,
                                                 /** index: ipAddressAddr */
                                     0);

    /*
     * Define the minimum and maximum accessible columns.  This
     * optimizes retrival. 
     */
    tbl_info->min_column = IPADDRESSTABLE_MIN_COL;
    tbl_info->max_column = IPADDRESSTABLE_MAX_COL;

    /*
     * save users context
     */
    ipAddressTable_if_ctx.user_ctx = reg_ptr;

    /*
     * call data access initialization code
     */
    ipAddressTable_init_data(reg_ptr);

    /*
     * set up the container
     */
    _ipAddressTable_container_init(&ipAddressTable_if_ctx);
    if (NULL == ipAddressTable_if_ctx.container) {
        snmp_log(LOG_ERR,
                 "could not initialize container for ipAddressTable\n");
        return;
    }

    /*
     * access_multiplexer: REQUIRED wrapper for get request handling
     */
    access_multiplexer->object_lookup = _mfd_ipAddressTable_object_lookup;
    access_multiplexer->get_values = _mfd_ipAddressTable_get_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->pre_request = _mfd_ipAddressTable_pre_request;
    access_multiplexer->post_request = _mfd_ipAddressTable_post_request;


    /*
     * REQUIRED wrappers for set request handling
     */
    access_multiplexer->object_syntax_checks =
        _mfd_ipAddressTable_check_objects;
    access_multiplexer->undo_setup = _mfd_ipAddressTable_undo_setup;
    access_multiplexer->undo_cleanup = _mfd_ipAddressTable_undo_cleanup;
    access_multiplexer->set_values = _mfd_ipAddressTable_set_values;
    access_multiplexer->undo_sets = _mfd_ipAddressTable_undo_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->commit = _mfd_ipAddressTable_commit;
    access_multiplexer->undo_commit = _mfd_ipAddressTable_undo_commit;

    /*
     * REQUIRED for tables with dependencies
     */
    access_multiplexer->consistency_checks =
        _mfd_ipAddressTable_check_dependencies;

    /*************************************************
     *
     * Create a registration, save our reg data, register table.
     */
    DEBUGMSGTL(("ipAddressTable:init_ipAddressTable",
                "Registering ipAddressTable as a mibs-for-dummies table.\n"));
    handler =
        netsnmp_baby_steps_access_multiplexer_get(access_multiplexer);
    reginfo =
        netsnmp_handler_registration_create("ipAddressTable", handler,
                                            ipAddressTable_oid,
                                            ipAddressTable_oid_size,
                                            HANDLER_CAN_BABY_STEP |
                                            HANDLER_CAN_RWRITE);
    if (NULL == reginfo) {
        snmp_log(LOG_ERR, "error registering table ipAddressTable\n");
        return;
    }
    reginfo->my_reg_void = &ipAddressTable_if_ctx;

    /*************************************************
     *
     * set up baby steps handler, create it and inject it
     */
    if (access_multiplexer->object_lookup)
        mfd_modes |= BABY_STEP_OBJECT_LOOKUP;
    if (access_multiplexer->set_values)
        mfd_modes |= BABY_STEP_SET_VALUES;
    if (access_multiplexer->irreversible_commit)
        mfd_modes |= BABY_STEP_IRREVERSIBLE_COMMIT;
    if (access_multiplexer->object_syntax_checks)
        mfd_modes |= BABY_STEP_CHECK_OBJECT;

    if (access_multiplexer->pre_request)
        mfd_modes |= BABY_STEP_PRE_REQUEST;
    if (access_multiplexer->post_request)
        mfd_modes |= BABY_STEP_POST_REQUEST;

    if (access_multiplexer->undo_setup)
        mfd_modes |= BABY_STEP_UNDO_SETUP;
    if (access_multiplexer->undo_cleanup)
        mfd_modes |= BABY_STEP_UNDO_CLEANUP;
    if (access_multiplexer->undo_sets)
        mfd_modes |= BABY_STEP_UNDO_SETS;

    if (access_multiplexer->row_creation)
        mfd_modes |= BABY_STEP_ROW_CREATE;
    if (access_multiplexer->consistency_checks)
        mfd_modes |= BABY_STEP_CHECK_CONSISTENCY;
    if (access_multiplexer->commit)
        mfd_modes |= BABY_STEP_COMMIT;
    if (access_multiplexer->undo_commit)
        mfd_modes |= BABY_STEP_UNDO_COMMIT;

    handler = netsnmp_baby_steps_handler_get(mfd_modes);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject row_merge helper with prefix rootoid_len + 2 (entry.col)
     */
    handler = netsnmp_get_row_merge_handler(reginfo->rootoid_len + 2);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject container_table helper
     */
    handler =
        netsnmp_container_table_handler_get(tbl_info,
                                            ipAddressTable_if_ctx.
                                            container,
                                            TABLE_CONTAINER_KEY_NETSNMP_INDEX);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject cache helper
     */
    if (NULL != ipAddressTable_if_ctx.cache) {
        handler = netsnmp_cache_handler_get(ipAddressTable_if_ctx.cache);
        netsnmp_inject_handler(reginfo, handler);
    }

    /*
     * register table
     */
    netsnmp_register_table(reginfo, tbl_info);
}                               /* _ipAddressTable_initialize_interface */

void
ipAddressTable_valid_columns_set(netsnmp_column_info *vc)
{
    ipAddressTable_if_ctx.tbl_info.valid_columns = vc;
}                               /* ipAddressTable_valid_columns_set */

/**
 * @internal
 * convert the index component stored in the context to an oid
 */
int
ipAddressTable_index_to_oid(netsnmp_index * oid_idx,
                            ipAddressTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ipAddressAddrType(1)/InetAddressType/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h
     */
    netsnmp_variable_list var_ipAddressAddrType;
    /*
     * ipAddressAddr(2)/InetAddress/ASN_OCTET_STR/char(char)//L/a/w/e/R/d/h
     */
    netsnmp_variable_list var_ipAddressAddr;

    /*
     * set up varbinds
     */
    memset(&var_ipAddressAddrType, 0x00, sizeof(var_ipAddressAddrType));
    var_ipAddressAddrType.type = ASN_INTEGER;
    memset(&var_ipAddressAddr, 0x00, sizeof(var_ipAddressAddr));
    var_ipAddressAddr.type = ASN_OCTET_STR;

    /*
     * chain temp index varbinds together
     */
    var_ipAddressAddrType.next_variable = &var_ipAddressAddr;
    var_ipAddressAddr.next_variable = NULL;


    DEBUGMSGTL(("verbose:ipAddressTable:ipAddressTable_index_to_oid",
                "called\n"));

    /*
     * ipAddressAddrType(1)/InetAddressType/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h 
     */
    snmp_set_var_value(&var_ipAddressAddrType,
                       (u_char *) & mib_idx->ipAddressAddrType,
                       sizeof(mib_idx->ipAddressAddrType));

    /*
     * ipAddressAddr(2)/InetAddress/ASN_OCTET_STR/char(char)//L/a/w/e/R/d/h 
     */
    snmp_set_var_value(&var_ipAddressAddr,
                       (u_char *) & mib_idx->ipAddressAddr,
                       mib_idx->ipAddressAddr_len *
                       sizeof(mib_idx->ipAddressAddr[0]));


    err = build_oid_noalloc(oid_idx->oids, oid_idx->len, &oid_idx->len,
                            NULL, 0, &var_ipAddressAddrType);
    if (err)
        snmp_log(LOG_ERR, "error %d converting index to oid\n");

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ipAddressAddrType);

    return err;
}                               /* ipAddressTable_index_to_oid */

/**
 * extract ipAddressTable indexes from a netsnmp_index
 *
 * @retval SNMP_ERR_NOERROR  : no error
 * @retval SNMP_ERR_GENERR   : error
 */
int
ipAddressTable_index_from_oid(netsnmp_index * oid_idx,
                              ipAddressTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ipAddressAddrType(1)/InetAddressType/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h
     */
    netsnmp_variable_list var_ipAddressAddrType;
    /*
     * ipAddressAddr(2)/InetAddress/ASN_OCTET_STR/char(char)//L/a/w/e/R/d/h
     */
    netsnmp_variable_list var_ipAddressAddr;

    /*
     * set up varbinds
     */
    memset(&var_ipAddressAddrType, 0x00, sizeof(var_ipAddressAddrType));
    var_ipAddressAddrType.type = ASN_INTEGER;
    memset(&var_ipAddressAddr, 0x00, sizeof(var_ipAddressAddr));
    var_ipAddressAddr.type = ASN_OCTET_STR;

    /*
     * chain temp index varbinds together
     */
    var_ipAddressAddrType.next_variable = &var_ipAddressAddr;
    var_ipAddressAddr.next_variable = NULL;


    DEBUGMSGTL(("verbose:ipAddressTable:ipAddressTable_index_from_oid",
                "called\n"));

    /*
     * parse the oid into the individual index components
     */
    err = parse_oid_indexes(oid_idx->oids, oid_idx->len,
                            &var_ipAddressAddrType);
    if (err == SNMP_ERR_NOERROR) {
        /*
         * copy out values
         */
        mib_idx->ipAddressAddrType =
            *((u_long *) var_ipAddressAddrType.val.string);
        /*
         * NOTE: val_len is in bytes, ipAddressAddr_len might not be
         */
        if (var_ipAddressAddr.val_len > sizeof(mib_idx->ipAddressAddr))
            err = SNMP_ERR_GENERR;
        else {
            memcpy(mib_idx->ipAddressAddr, var_ipAddressAddr.val.string,
                   var_ipAddressAddr.val_len);
            mib_idx->ipAddressAddr_len =
                var_ipAddressAddr.val_len /
                sizeof(mib_idx->ipAddressAddr[0]);
        }


    }

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ipAddressAddrType);

    return err;
}                               /* ipAddressTable_index_from_oid */


/*
 *********************************************************************
 * @internal
 * allocate resources for a ipAddressTable_rowreq_ctx
 */
ipAddressTable_rowreq_ctx *
ipAddressTable_allocate_rowreq_ctx(ipAddressTable_data * data)
{
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        SNMP_MALLOC_TYPEDEF(ipAddressTable_rowreq_ctx);

    DEBUGMSGTL(("internal:ipAddressTable:ipAddressTable_allocate_rowreq_ctx", "called\n"));

    if (NULL == rowreq_ctx) {
        snmp_log(LOG_ERR, "Couldn't allocate memory for a "
                 "ipAddressTable_rowreq_ctx.\n");
    } else {
        if (NULL != data) {
            rowreq_ctx->data = data;
        } else if (NULL ==
                   (rowreq_ctx->data = ipAddressTable_allocate_data())) {
            SNMP_FREE(rowreq_ctx);
            return NULL;
        }
    }

    /*
     * undo context will be allocated when needed (in *_undo_setup)
     */

    rowreq_ctx->oid_idx.oids = rowreq_ctx->oid_tmp;

    rowreq_ctx->ipAddressTable_data_list = NULL;
    rowreq_ctx->ipAddressTable_reg = ipAddressTable_if_ctx.user_ctx;


    return rowreq_ctx;
}                               /* ipAddressTable_allocate_rowreq_ctx */

/*
 * @internal
 * release resources for a ipAddressTable_rowreq_ctx
 */
void
ipAddressTable_release_rowreq_ctx(ipAddressTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("internal:ipAddressTable:ipAddressTable_release_rowreq_ctx", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);


    if (rowreq_ctx->data)
        ipAddressTable_release_data(rowreq_ctx->data);

    if (rowreq_ctx->undo)
        ipAddressTable_release_data(rowreq_ctx->undo);

    /*
     * free index oid pointer
     */
    if (rowreq_ctx->oid_idx.oids != rowreq_ctx->oid_tmp)
        free(rowreq_ctx->oid_idx.oids);

    SNMP_FREE(rowreq_ctx);
}                               /* ipAddressTable_release_rowreq_ctx */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipAddressTable_pre_request(netsnmp_mib_handler *handler,
                                netsnmp_handler_registration *reginfo,
                                netsnmp_agent_request_info *agtreq_info,
                                netsnmp_request_info *requests)
{
    int             rc =
        ipAddressTable_pre_request(ipAddressTable_if_ctx.user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("internal:ipAddressTable", "error %d from "
                    "ipAddressTable_pre_request\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_pre_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipAddressTable_post_request(netsnmp_mib_handler *handler,
                                 netsnmp_handler_registration *reginfo,
                                 netsnmp_agent_request_info *agtreq_info,
                                 netsnmp_request_info *requests)
{
    ipAddressTable_rowreq_ctx *rowreq_ctx;
    int             rc =
        ipAddressTable_post_request(ipAddressTable_if_ctx.user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("internal:ipAddressTable", "error %d from "
                    "ipAddressTable_post_request\n", rc));
    }

    /*
     * if it was set, clear row created flag.
     */
    rowreq_ctx = netsnmp_container_table_row_extract(requests);
    if ((NULL != rowreq_ctx)
        && (rowreq_ctx->rowreq_flags & MFD_ROW_CREATED))
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_CREATED;

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_post_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipAddressTable_object_lookup(netsnmp_mib_handler *handler,
                                  netsnmp_handler_registration *reginfo,
                                  netsnmp_agent_request_info *agtreq_info,
                                  netsnmp_request_info *requests)
{
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_object_lookup", "called\n"));

    /*
     * get our context from mfd
     * ipAddressTable_interface_ctx *if_ctx =
     *             (ipAddressTable_interface_ctx *)reginfo->my_reg_void;
     */

    if (NULL == rowreq_ctx) {
#define NETSNMP_IPADDRESSTABLE_CREATE_SUPPORT 1
#ifndef NETSNMP_IPADDRESSTABLE_CREATE_SUPPORT
        netsnmp_request_set_error(requests, SNMP_ERR_NOCREATION);
#else
        int             rc = MFD_SUCCESS;
        netsnmp_table_request_info *tblreq_info;
        netsnmp_index   oid_idx;
        ipAddressTable_mib_index mib_idx;

        tblreq_info = netsnmp_extract_table_info(requests);
        if (NULL == tblreq_info) {
            snmp_log(LOG_ERR, "request had no table info\n");
            return MFD_ERROR;
        }

        /*
         * try to parse oid
         */
        oid_idx.oids = tblreq_info->index_oid;
        oid_idx.len = tblreq_info->index_oid_len;
        rc = ipAddressTable_index_from_oid(&oid_idx, &mib_idx);
        if (MFD_SUCCESS != rc) {
            DEBUGMSGT(("ipAddressTable", "error parsing index\n"));
            netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
        } else {
            /*
             * allocate new context
             */
            rowreq_ctx = ipAddressTable_allocate_rowreq_ctx(NULL);
            if (NULL == rowreq_ctx)
                return MFD_ERROR;       /* msg already logged */

            memcpy(&rowreq_ctx->tbl_idx, &mib_idx, sizeof(mib_idx));

            /*
             * check indexes
             */
            rc = _ipAddressTable_check_indexes(rowreq_ctx);
            if (MFD_SUCCESS != rc) {
                netsnmp_assert((rc == SNMP_ERR_NOCREATION) ||
                               (rc == SNMP_ERR_INCONSISTENTNAME));
                netsnmp_request_set_error_all(requests,
                                              SNMP_VALIDATE_ERR(rc));
                ipAddressTable_release_rowreq_ctx(rowreq_ctx);
            } else {
                rowreq_ctx->rowreq_flags |= MFD_ROW_CREATED;
                netsnmp_container_table_row_insert(requests, rowreq_ctx);
            }
        }
#endif                          /* NETSNMP_IPADDRESSTABLE_CREATE_SUPPORT */
    } else {
        ipAddressTable_row_prep(rowreq_ctx);
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_object_lookup */

/***********************************************************************
 *
 * GET processing
 *
 ***********************************************************************/
/*
 * @internal
 * Retrieve the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipAddressTable_get_column(ipAddressTable_rowreq_ctx * rowreq_ctx,
                           netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_get_column",
                "called\n"));


    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipAddressIfIndex(3)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/W/e/R/d/H 
         */
    case COLUMN_IPADDRESSIFINDEX:
        var->val_len = sizeof(long);
        var->type = ASN_INTEGER;
        rc = ipAddressIfIndex_get(rowreq_ctx, (long *) var->val.string);
        break;

        /*
         * ipAddressType(4)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSTYPE:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ipAddressType_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ipAddressPrefix(5)/RowPointer/ASN_OBJECT_ID/oid(oid)//L/A/w/e/r/D/h 
         */
    case COLUMN_IPADDRESSPREFIX:
        var->type = ASN_OBJECT_ID;
        rc = ipAddressPrefix_get(rowreq_ctx, (oid **) & var->val.string,
                                 &var->val_len);
        break;

        /*
         * ipAddressOrigin(6)/IpAddressOriginTC/ASN_INTEGER/long(u_long)//l/A/w/E/r/d/h 
         */
    case COLUMN_IPADDRESSORIGIN:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ipAddressOrigin_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ipAddressStatus(7)/IpAddressStatusTC/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTATUS:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ipAddressStatus_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ipAddressCreated(8)/TimeStamp/ASN_TIMETICKS/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPADDRESSCREATED:
        var->val_len = sizeof(u_long);
        var->type = ASN_TIMETICKS;
        rc = ipAddressCreated_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ipAddressLastChanged(9)/TimeStamp/ASN_TIMETICKS/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPADDRESSLASTCHANGED:
        var->val_len = sizeof(u_long);
        var->type = ASN_TIMETICKS;
        rc = ipAddressLastChanged_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

        /*
         * ipAddressRowStatus(10)/RowStatus/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPADDRESSROWSTATUS:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ipAddressRowStatus_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ipAddressStorageType(11)/StorageType/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTORAGETYPE:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ipAddressStorageType_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipAddressTable_get_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ipAddressTable_get_column */

int
_mfd_ipAddressTable_get_values(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *agtreq_info,
                               netsnmp_request_info *requests)
{
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    u_char         *old_string;
    void            (*dataFreeHook) (void *);
    int             rc;

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_get_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * save old pointer, so we can free it if replaced
         */
        old_string = requests->requestvb->val.string;
        dataFreeHook = requests->requestvb->dataFreeHook;
        if (NULL == requests->requestvb->val.string) {
            requests->requestvb->val.string = requests->requestvb->buf;
            requests->requestvb->val_len =
                sizeof(requests->requestvb->buf);
        } else if (requests->requestvb->buf ==
                   requests->requestvb->val.string) {
            if (requests->requestvb->val_len !=
                sizeof(requests->requestvb->buf))
                requests->requestvb->val_len =
                    sizeof(requests->requestvb->buf);
        }

        /*
         * get column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipAddressTable_get_column(rowreq_ctx, requests->requestvb,
                                        tri->colnum);
        if (rc) {
            if (MFD_SKIP == rc) {
                requests->requestvb->type = ASN_PRIV_RETRY;
                rc = SNMP_ERR_NOERROR;
            }
        } else if (NULL == requests->requestvb->val.string) {
            snmp_log(LOG_ERR, "NULL varbind data pointer!\n");
            rc = SNMP_ERR_GENERR;
        }
        if (rc)
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));

        /*
         * if the buffer wasn't used previously for the old data (i.e. it
         * was allcoated memory)  and the get routine replaced the pointer,
         * we need to free the previous pointer.
         */
        if (old_string && (old_string != requests->requestvb->buf) &&
            (requests->requestvb->val.string != old_string)) {
            if (dataFreeHook)
                (*dataFreeHook) (old_string);
            else
                free(old_string);
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_get_values */

/***********************************************************************
 *
 * SET processing
 *
 ***********************************************************************/

/*----------------------------------------------------------------------
 *
 * SET: Syntax checks
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check the syntax for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipAddressTable_check_column(ipAddressTable_rowreq_ctx * rowreq_ctx,
                             netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipAddressTable:_ipAddressTable_check_column",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipAddressIfIndex(3)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/W/e/R/d/H 
         */
    case COLUMN_IPADDRESSIFINDEX:
        rc = netsnmp_check_vb_type(var, ASN_INTEGER);
        if (SNMPERR_SUCCESS == rc) {
            /*
             * check that the value is in the defined range(s); inefficent
             * * but keeps rc value knowledge in libarary where it belongs. 
             */
            if (1 && ((rc = netsnmp_check_vb_int_range(var, 1, 2147483647))
                      != SNMP_ERR_NOERROR)
                ) {
                ;               /* rc set in condition */
            }
        }
        if (SNMPERR_SUCCESS == rc) {
            rc = ipAddressIfIndex_check_value(rowreq_ctx,
                                              *((long *) var->val.string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ipAddressIfIndex_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ipAddressType(4)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSTYPE:
        rc = netsnmp_check_vb_type(var, ASN_INTEGER);
        if (SNMPERR_SUCCESS == rc) {

            /*
             * check that the value is one of defined enums 
             */
            if (1 && (*var->val.integer != IPADDRESSTYPE_UNICAST)
                && (*var->val.integer != IPADDRESSTYPE_ANYCAST)
                && (*var->val.integer != IPADDRESSTYPE_BROADCAST)
                ) {
                rc = SNMP_ERR_WRONGVALUE;
            }
        }
        if (SNMPERR_SUCCESS == rc) {
            rc = ipAddressType_check_value(rowreq_ctx,
                                           *((u_long *) var->val.string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ipAddressType_check_value\n", rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ipAddressStatus(7)/IpAddressStatusTC/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTATUS:
        rc = netsnmp_check_vb_type(var, ASN_INTEGER);
        if (SNMPERR_SUCCESS == rc) {

            /*
             * check that the value is one of defined enums 
             */
            if (1 && (*var->val.integer != IPADDRESSSTATUSTC_PREFERRED)
                && (*var->val.integer != IPADDRESSSTATUSTC_INVALID)
                && (*var->val.integer != IPADDRESSSTATUSTC_INACCESSIBLE)
                && (*var->val.integer != IPADDRESSSTATUSTC_UNKNOWN)
                && (*var->val.integer != IPADDRESSSTATUSTC_TENTATIVE)
                && (*var->val.integer != IPADDRESSSTATUSTC_DUPLICATE)
                ) {
                rc = SNMP_ERR_WRONGVALUE;
            }
        }
        if (SNMPERR_SUCCESS == rc) {
            rc = ipAddressStatus_check_value(rowreq_ctx,
                                             *((u_long *) var->val.
                                               string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ipAddressStatus_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ipAddressRowStatus(10)/RowStatus/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPADDRESSROWSTATUS:
        rc = netsnmp_check_vb_rowstatus_value(var);
        if (SNMPERR_SUCCESS == rc) {
            rc = ipAddressRowStatus_check_value(rowreq_ctx,
                                                *((u_long *) var->val.
                                                  string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ipAddressRowStatus_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ipAddressStorageType(11)/StorageType/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTORAGETYPE:
        rc = netsnmp_check_vb_type(var, ASN_INTEGER);
        if (SNMPERR_SUCCESS == rc) {

            /*
             * check that the value is one of defined enums 
             */
            if (1 && (*var->val.integer != STORAGETYPE_OTHER)
                && (*var->val.integer != STORAGETYPE_VOLATILE)
                && (*var->val.integer != STORAGETYPE_NONVOLATILE)
                && (*var->val.integer != STORAGETYPE_PERMANENT)
                && (*var->val.integer != STORAGETYPE_READONLY)
                ) {
                rc = SNMP_ERR_WRONGVALUE;
            }
        }
        if (SNMPERR_SUCCESS == rc) {
            rc = ipAddressStorageType_check_value(rowreq_ctx,
                                                  *((u_long *) var->val.
                                                    string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ipAddressStorageType_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

    default:   /** We shouldn't get here */
        rc = SNMP_ERR_GENERR;
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipAddressTable_check_column\n",
                 column);
    }

    return rc;
}                               /* _ipAddressTable_check_column */

int
_mfd_ipAddressTable_check_objects(netsnmp_mib_handler *handler,
                                  netsnmp_handler_registration *reginfo,
                                  netsnmp_agent_request_info *agtreq_info,
                                  netsnmp_request_info *requests)
{
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc;

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_check_objects", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {

        /*
         * get column number from table request info, and check that column
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipAddressTable_check_column(rowreq_ctx, requests->requestvb,
                                          tri->colnum);
        if (rc) {
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));
            break;
        }

    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_check_objects */

NETSNMP_STATIC_INLINE int
_ipAddressTable_check_indexes(ipAddressTable_rowreq_ctx * rowreq_ctx)
{
    int             rc;

    DEBUGMSGTL(("internal:ipAddressTable:_ipAddressTable_check_indexes",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);


    /*
     * (INDEX) ipAddressAddrType(1)/InetAddressType/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h 
     */
    rc = ipAddressAddrType_check_index(rowreq_ctx);
    if (MFD_SUCCESS != rc)
        return SNMP_ERR_NOCREATION;

    /*
     * (INDEX) ipAddressAddr(2)/InetAddress/ASN_OCTET_STR/char(char)//L/a/w/e/R/d/h 
     */
    rc = ipAddressAddr_check_index(rowreq_ctx);
    if (MFD_SUCCESS != rc)
        return SNMP_ERR_NOCREATION;

    /*
     * if individual parts look ok, check them as a whole
     */
    return ipAddressTable_validate_index(rowreq_ctx->ipAddressTable_reg,
                                         rowreq_ctx);
}                               /* _ipAddressTable_check_indexes */


/*----------------------------------------------------------------------
 *
 * SET: check dependencies
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check dependencies wrapper
 */
static int
_mfd_ipAddressTable_check_dependencies(netsnmp_mib_handler *handler, netsnmp_handler_registration
                                       *reginfo, netsnmp_agent_request_info
                                       *agtreq_info,
                                       netsnmp_request_info *requests)
{
    int             rc;
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_check_dependencies", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ipAddressTable_check_dependencies(rowreq_ctx);
    if (rc) {
        DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                    "ipAddressTable_check_dependencies\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_check_dependencies */

/*----------------------------------------------------------------------
 *
 * SET: Undo setup
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipAddressTable_undo_setup_column(ipAddressTable_rowreq_ctx * rowreq_ctx,
                                  int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipAddressTable:_ipAddressTable_undo_setup_column", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipAddressIfIndex(3)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/W/e/R/d/H 
         */
    case COLUMN_IPADDRESSIFINDEX:
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSIFINDEX;
        rc = ipAddressIfIndex_undo_setup(rowreq_ctx);
        break;

        /*
         * ipAddressType(4)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSTYPE:
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSTYPE;
        rc = ipAddressType_undo_setup(rowreq_ctx);
        break;

        /*
         * ipAddressStatus(7)/IpAddressStatusTC/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTATUS:
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSSTATUS;
        rc = ipAddressStatus_undo_setup(rowreq_ctx);
        break;

        /*
         * ipAddressRowStatus(10)/RowStatus/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPADDRESSROWSTATUS:
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSROWSTATUS;
        rc = ipAddressRowStatus_undo_setup(rowreq_ctx);
        break;

        /*
         * ipAddressStorageType(11)/StorageType/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTORAGETYPE:
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSSTORAGETYPE;
        rc = ipAddressStorageType_undo_setup(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipAddressTable_undo_setup_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ipAddressTable_undo_setup_column */


/**
 * @internal
 * undo setup
 */
int
_mfd_ipAddressTable_undo_setup(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *agtreq_info,
                               netsnmp_request_info *requests)
{
    int             rc;
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_undo_setup",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * allocate undo context
     */
    rowreq_ctx->undo = ipAddressTable_allocate_data();
    if (NULL == rowreq_ctx->undo) {
        /** msg already logged */
        netsnmp_request_set_error_all(requests,
                                      SNMP_ERR_RESOURCEUNAVAILABLE);
        return SNMP_ERR_NOERROR;
    }

    /*
     * row undo setup
     */
    rowreq_ctx->column_set_flags = 0;
    rc = ipAddressTable_undo_setup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                    "ipAddressTable_undo_setup\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    } else {
        /*
         * column undo setup
         */
        netsnmp_table_request_info *tri;
        for (; requests; requests = requests->next) {
            /*
             * set column data
             */
            tri = netsnmp_extract_table_info(requests);
            if (NULL == tri)
                continue;

            rc = _ipAddressTable_undo_setup_column(rowreq_ctx,
                                                   tri->colnum);
            if (MFD_SUCCESS != rc) {
                DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                            "ipAddressTable_undo_setup_column\n", rc));
                netsnmp_set_request_error(agtreq_info, requests,
                                          SNMP_VALIDATE_ERR(rc));
            }
        }                       /* for results */
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_undo_setup */

/**
 * @internal
 * undo setup
 */
int
_mfd_ipAddressTable_undo_cleanup(netsnmp_mib_handler *handler,
                                 netsnmp_handler_registration *reginfo,
                                 netsnmp_agent_request_info *agtreq_info,
                                 netsnmp_request_info *requests)
{
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    int             rc;

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_undo_cleanup",
                "called\n"));

    /*
     * failed row create in early stages has no rowreq_ctx
     */
    if (NULL == rowreq_ctx)
        return MFD_SUCCESS;

    /*
     * call user cleanup
     */
    rc = ipAddressTable_undo_cleanup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                    "ipAddressTable_undo_cleanup\n", rc));
    }

    /*
     * release undo context, if needed
     */
    if (rowreq_ctx->undo) {
        ipAddressTable_release_data(rowreq_ctx->undo);
        rowreq_ctx->undo = NULL;
    }

    /*
     * clear set flags
     */
    rowreq_ctx->column_set_flags = 0;

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_undo_cleanup */

/*----------------------------------------------------------------------
 *
 * SET: Set values
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipAddressTable_set_column(ipAddressTable_rowreq_ctx * rowreq_ctx,
                           netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipAddressTable:_ipAddressTable_set_column",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipAddressIfIndex(3)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/W/e/R/d/H 
         */
    case COLUMN_IPADDRESSIFINDEX:
        if (var->val_len != sizeof(long)) {
            rc = SNMP_ERR_WRONGLENGTH;
            snmp_log(LOG_ERR,
                     "varbind size of %d does not match expected size %d\n",
                     var->val_len, sizeof(long));
            break;
        }
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSIFINDEX;
        rc = ipAddressIfIndex_set(rowreq_ctx, *((long *) var->val.string));
        break;

        /*
         * ipAddressType(4)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSTYPE:
        if (var->val_len != sizeof(u_long)) {
            rc = SNMP_ERR_WRONGLENGTH;
            snmp_log(LOG_ERR,
                     "varbind size of %d does not match expected size %d\n",
                     var->val_len, sizeof(u_long));
            break;
        }
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSTYPE;
        rc = ipAddressType_set(rowreq_ctx, *((u_long *) var->val.string));
        break;

        /*
         * ipAddressStatus(7)/IpAddressStatusTC/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTATUS:
        if (var->val_len != sizeof(u_long)) {
            rc = SNMP_ERR_WRONGLENGTH;
            snmp_log(LOG_ERR,
                     "varbind size of %d does not match expected size %d\n",
                     var->val_len, sizeof(u_long));
            break;
        }
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSSTATUS;
        rc = ipAddressStatus_set(rowreq_ctx,
                                 *((u_long *) var->val.string));
        break;

        /*
         * ipAddressRowStatus(10)/RowStatus/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPADDRESSROWSTATUS:
        if (var->val_len != sizeof(u_long)) {
            rc = SNMP_ERR_WRONGLENGTH;
            snmp_log(LOG_ERR,
                     "varbind size of %d does not match expected size %d\n",
                     var->val_len, sizeof(u_long));
            break;
        }
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSROWSTATUS;
        rc = ipAddressRowStatus_set(rowreq_ctx,
                                    *((u_long *) var->val.string));
        break;

        /*
         * ipAddressStorageType(11)/StorageType/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTORAGETYPE:
        if (var->val_len != sizeof(u_long)) {
            rc = SNMP_ERR_WRONGLENGTH;
            snmp_log(LOG_ERR,
                     "varbind size of %d does not match expected size %d\n",
                     var->val_len, sizeof(u_long));
            break;
        }
        rowreq_ctx->column_set_flags |= FLAG_IPADDRESSSTORAGETYPE;
        rc = ipAddressStorageType_set(rowreq_ctx,
                                      *((u_long *) var->val.string));
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipAddressTable_set_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ipAddressTable_set_column */

int
_mfd_ipAddressTable_set_values(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *agtreq_info,
                               netsnmp_request_info *requests)
{
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc = SNMP_ERR_NOERROR;

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_set_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rowreq_ctx->column_set_flags = 0;
    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipAddressTable_set_column(rowreq_ctx,
                                        requests->requestvb, tri->colnum);
        if (MFD_SUCCESS != rc) {
            DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                        "ipAddressTable_set_column\n", rc));
            netsnmp_set_request_error(agtreq_info, requests,
                                      SNMP_VALIDATE_ERR(rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_set_values */

/*----------------------------------------------------------------------
 *
 * SET: commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit the values
 */
int
_mfd_ipAddressTable_commit(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *agtreq_info,
                           netsnmp_request_info *requests)
{
    int             rc;
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_commit",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ipAddressTable_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                    "ipAddressTable_commit\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}

int
_mfd_ipAddressTable_undo_commit(netsnmp_mib_handler *handler,
                                netsnmp_handler_registration *reginfo,
                                netsnmp_agent_request_info *agtreq_info,
                                netsnmp_request_info *requests)
{
    int             rc;
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_undo_commit",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ipAddressTable_undo_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                    "ipAddressTable_undo_commit\n", rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_commit */

/*----------------------------------------------------------------------
 *
 * SET: Undo
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * undo the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipAddressTable_undo_column(ipAddressTable_rowreq_ctx * rowreq_ctx,
                            netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipAddressTable:_ipAddressTable_undo_column",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipAddressIfIndex(3)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/W/e/R/d/H 
         */
    case COLUMN_IPADDRESSIFINDEX:
        rc = ipAddressIfIndex_undo(rowreq_ctx);
        break;

        /*
         * ipAddressType(4)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSTYPE:
        rc = ipAddressType_undo(rowreq_ctx);
        break;

        /*
         * ipAddressStatus(7)/IpAddressStatusTC/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTATUS:
        rc = ipAddressStatus_undo(rowreq_ctx);
        break;

        /*
         * ipAddressRowStatus(10)/RowStatus/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IPADDRESSROWSTATUS:
        rc = ipAddressRowStatus_undo(rowreq_ctx);
        break;

        /*
         * ipAddressStorageType(11)/StorageType/ASN_INTEGER/long(u_long)//l/A/W/E/r/D/h 
         */
    case COLUMN_IPADDRESSSTORAGETYPE:
        rc = ipAddressStorageType_undo(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ipAddressTable_undo_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ipAddressTable_undo_column */

int
_mfd_ipAddressTable_undo_values(netsnmp_mib_handler *handler,
                                netsnmp_handler_registration *reginfo,
                                netsnmp_agent_request_info *agtreq_info,
                                netsnmp_request_info *requests)
{
    int             rc;
    ipAddressTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;

    DEBUGMSGTL(("internal:ipAddressTable:_mfd_ipAddressTable_undo_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipAddressTable_undo_column(rowreq_ctx, requests->requestvb,
                                         tri->colnum);
        if (MFD_SUCCESS != rc) {
            /*
             * nothing we can do about it but log it
             */
            DEBUGMSGTL(("verbose:ipAddressTable:mfd", "error %d from "
                        "ipAddressTable_undo_column\n", rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipAddressTable_undo_values */

/***********************************************************************
 *
 * DATA ACCESS
 *
 ***********************************************************************/
/**
 * @internal
 */
static int
_cache_load(netsnmp_cache * cache, void *vmagic)
{
    DEBUGMSGTL(("internal:ipAddressTable:_cache_load", "called\n"));

    if ((NULL == cache) || (NULL == cache->magic)) {
        snmp_log(LOG_ERR, "invalid cache for ipAddressTable_cache_load\n");
        return -1;
    }

    /** should only be called for an invalid or expired cache */
    netsnmp_assert((0 == cache->valid) || (1 == cache->expired));

    /*
     * call user code
     */
    return ipAddressTable_cache_load((netsnmp_container *) cache->magic);
}                               /* _cache_load */

/**
 * @internal
 */
static void
_cache_item_free(ipAddressTable_rowreq_ctx * rowreq_ctx, void *context)
{
    DEBUGMSGTL(("internal:ipAddressTable:_cache_item_free", "called\n"));

    if (NULL == rowreq_ctx)
        return;

    ipAddressTable_release_rowreq_ctx(rowreq_ctx);
}                               /* _cache_item_free */

/**
 * @internal
 */
static void
_cache_free(netsnmp_cache * cache, void *magic)
{
    netsnmp_container *container;

    DEBUGMSGTL(("internal:ipAddressTable:_cache_free", "called\n"));

    if ((NULL == cache) || (NULL == cache->magic)) {
        snmp_log(LOG_ERR, "invalid cache in ipAddressTable_cache_free\n");
        return;
    }

    container = (netsnmp_container *) cache->magic;

    /*
     * call user code
     */
    ipAddressTable_cache_free(container);

    /*
     * free all items. inefficient, but easy.
     */
    CONTAINER_CLEAR(container,
                    (netsnmp_container_obj_func *) _cache_item_free, NULL);
}                               /* _cache_free */

/**
 * @internal
 * initialize the iterator container with functions or wrappers
 */
void
_ipAddressTable_container_init(ipAddressTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:ipAddressTable:_ipAddressTable_container_init",
                "called\n"));

    /*
     * set up the cache
     */
    if_ctx->cache = netsnmp_cache_create(30,    /* timeout in seconds */
                                         _cache_load, _cache_free,
                                         ipAddressTable_oid,
                                         ipAddressTable_oid_size);

    if (NULL == if_ctx->cache) {
        snmp_log(LOG_ERR, "error creating cache for ipAddressTable\n");
        return;
    }

    if_ctx->cache->flags = NETSNMP_CACHE_DONT_INVALIDATE_ON_SET;

    ipAddressTable_container_init(&if_ctx->container, if_ctx->cache);
    if (NULL == if_ctx->container)
        if_ctx->container =
            netsnmp_container_find("ipAddressTable:table_container");
    if (NULL == if_ctx->container) {
        snmp_log(LOG_ERR, "error creating container in "
                 "ipAddressTable_container_init\n");
        return;
    }
    if_ctx->cache->magic = (void *) if_ctx->container;
}                               /* _ipAddressTable_container_init */
